package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 */

public class RequestTypeConverterTest extends AbstractMockMvcTests {

	private RequestTypeConverter requestTypeConverter;

	@Before
	public void setUp() {

		requestTypeConverter = new RequestTypeConverter();
	}

	@Test
	public void convert() {

		assertEquals("VINCI Data Request", requestTypeConverter.convert(Helper.getNewRequestType()).getDescription());
		assertNotSame("Aggregate", requestTypeConverter.convert(Helper.getNewRequestType()).getDescription());
	}

	@Test
	public void convert2() {

		assertEquals("VINCI Data Request", requestTypeConverter.convert(Helper.getRequestTypeDTO()).getDescription());
		assertNotSame("Aggregate", requestTypeConverter.convert(Helper.getRequestTypeDTO()).getDescription());
	}

	@Test
	public void convertRequestTypes() {

		List<RequestType> requestTypes = new ArrayList<>();
		requestTypes.add(Helper.getNewRequestType());

		assertTrue(!requestTypeConverter.convertRequestTypes(requestTypes).isEmpty());
		assertFalse(requestTypeConverter.convertRequestTypes(requestTypes).isEmpty());

	}

	@Test
	public void convertRequestTypesWithId() {

		List<RequestType> requestTypes = new ArrayList<>();
		RequestType requestType1 = Helper.getNewRequestType();
		RequestType requestType2 = Helper.getNewRequestType();
		requestType2.setId(2);

		requestTypes.add(requestType1);
		requestTypes.add(requestType2);
		assertTrue(!requestTypeConverter.convertRequestTypes(requestTypes, 1).isEmpty());
		assertFalse(requestTypeConverter.convertRequestTypes(requestTypes, 1).isEmpty());
		assertTrue(!requestTypeConverter.convertRequestTypes(requestTypes, 2).isEmpty());
		assertFalse(requestTypeConverter.convertRequestTypes(requestTypes, 2).isEmpty());
		assertFalse(requestTypeConverter.convertRequestTypes(requestTypes, 4).isEmpty());

	}

}
